import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Plot the distribution of original and updated odds
plt.figure(figsize=(12, 6))
sns.kdeplot(updated_odds_df['Original Odd_1'], label='Original Odd_1', fill=True)
sns.kdeplot(updated_odds_df['Updated Odd_1'], label='Updated Odd_1', fill=True)
plt.xlabel('Odds')
plt.ylabel('Density')
plt.title('Distribution of Original and Updated Odds for Player 1')
plt.legend()
plt.savefig('./ref_result/updated_odds_change_for_player_1.png')
plt.show()

plt.figure(figsize=(12, 6))
sns.kdeplot(updated_odds_df['Original Odd_2'], label='Original Odd_2', fill=True)
sns.kdeplot(updated_odds_df['Updated Odd_2'], label='Updated Odd_2', fill=True)
plt.xlabel('Odds')
plt.ylabel('Density')
plt.title('Distribution of Original and Updated Odds for Player 2')
plt.legend()
plt.savefig('./ref_result/updated_odds_change_for_player_2.png')
plt.show()

# Plot the changes in match favorites
plt.figure(figsize=(12, 6))
sns.countplot(x='Change in Favorite', data=later_rounds_odds)
plt.xlabel('Change in Match Favorite')
plt.ylabel('Count')
plt.title('Changes in Match Favorites Based on Updated Odds')
plt.savefig('./ref_result/changes_in_match_favorites.png')
plt.show()

# Plot the shifts in tournament dynamics
plt.figure(figsize=(12, 6))
sns.lineplot(x='Match ID', y='Shift in Tournament Dynamics', data=later_rounds_odds)
plt.xlabel('Match ID')
plt.ylabel('Shift in Tournament Dynamics')
plt.title('Shifts in Tournament Dynamics Based on Updated Odds')
plt.savefig('./ref_result/shifts_in_tournament_dynamics.png')
plt.show()
